/*
 * Decompiled with CFR 0.152.
 */
package mcjty.tools.rules;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.incontrol.ErrorHandler;
import mcjty.tools.cache.StructureCache;
import mcjty.tools.rules.CommonRuleKeys;
import mcjty.tools.rules.IEventQuery;
import mcjty.tools.rules.IModRuleCompatibilityLayer;
import mcjty.tools.typed.AttributeMap;
import mcjty.tools.typed.Key;
import mcjty.tools.varia.LookAtTools;
import mcjty.tools.varia.Tools;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;

public class CommonRuleEvaluator {
    protected final List<BiFunction<Object, IEventQuery, Boolean>> checks = new ArrayList<BiFunction<Object, IEventQuery, Boolean>>();
    private final Logger logger;
    private final IModRuleCompatibilityLayer compatibility;
    private static Random rnd = new Random();
    private static final int[] EMPTYINTS = new int[0];

    public CommonRuleEvaluator(AttributeMap map, Logger logger, IModRuleCompatibilityLayer compatibility) {
        this.logger = logger;
        this.compatibility = compatibility;
        this.addChecks(map);
    }

    protected void addChecks(AttributeMap map) {
        if (map.has(CommonRuleKeys.RANDOM)) {
            this.addRandomCheck(map);
        }
        if (map.has(CommonRuleKeys.DIMENSION)) {
            this.addDimensionCheck(map);
        }
        if (map.has(CommonRuleKeys.DIMENSION_MOD)) {
            this.addDimensionModCheck(map);
        }
        if (map.has(CommonRuleKeys.MINTIME)) {
            this.addMinTimeCheck(map);
        }
        if (map.has(CommonRuleKeys.MAXTIME)) {
            this.addMaxTimeCheck(map);
        }
        if (map.has(CommonRuleKeys.MINHEIGHT)) {
            this.addMinHeightCheck(map);
        }
        if (map.has(CommonRuleKeys.MAXHEIGHT)) {
            this.addMaxHeightCheck(map);
        }
        if (map.has(CommonRuleKeys.WEATHER)) {
            this.addWeatherCheck(map);
        }
        if (map.has(CommonRuleKeys.CATEGORY)) {
            this.addCategoryCheck(map);
        }
        if (map.has(CommonRuleKeys.DIFFICULTY)) {
            this.addDifficultyCheck(map);
        }
        if (map.has(CommonRuleKeys.MINSPAWNDIST)) {
            this.addMinSpawnDistCheck(map);
        }
        if (map.has(CommonRuleKeys.MAXSPAWNDIST)) {
            this.addMaxSpawnDistCheck(map);
        }
        if (map.has(CommonRuleKeys.MINLIGHT)) {
            this.addMinLightCheck(map);
        }
        if (map.has(CommonRuleKeys.MAXLIGHT)) {
            this.addMaxLightCheck(map);
        }
        if (map.has(CommonRuleKeys.MINDIFFICULTY)) {
            this.addMinAdditionalDifficultyCheck(map);
        }
        if (map.has(CommonRuleKeys.MAXDIFFICULTY)) {
            this.addMaxAdditionalDifficultyCheck(map);
        }
        if (map.has(CommonRuleKeys.SEESKY)) {
            this.addSeeSkyCheck(map);
        }
        if (map.has(CommonRuleKeys.BLOCK)) {
            this.addBlocksCheck(map);
        }
        if (map.has(CommonRuleKeys.BIOME)) {
            this.addBiomesCheck(map);
        }
        if (map.has(CommonRuleKeys.BIOMETYPE)) {
            this.addBiomeTypesCheck(map);
        }
        if (map.has(CommonRuleKeys.HELMET)) {
            this.addHelmetCheck(map);
        }
        if (map.has(CommonRuleKeys.CHESTPLATE)) {
            this.addChestplateCheck(map);
        }
        if (map.has(CommonRuleKeys.LEGGINGS)) {
            this.addLeggingsCheck(map);
        }
        if (map.has(CommonRuleKeys.BOOTS)) {
            this.addBootsCheck(map);
        }
        if (map.has(CommonRuleKeys.PLAYER_HELDITEM)) {
            this.addHeldItemCheck(map, CommonRuleKeys.PLAYER_HELDITEM);
        }
        if (map.has(CommonRuleKeys.HELDITEM)) {
            this.addHeldItemCheck(map, CommonRuleKeys.HELDITEM);
        }
        if (map.has(CommonRuleKeys.OFFHANDITEM)) {
            this.addOffHandItemCheck(map);
        }
        if (map.has(CommonRuleKeys.BOTHHANDSITEM)) {
            this.addBothHandsItemCheck(map);
        }
        if (map.has(CommonRuleKeys.STRUCTURE)) {
            this.addStructureCheck(map);
        }
        if (map.has(CommonRuleKeys.STATE)) {
            if (this.compatibility.hasEnigmaScript()) {
                this.addStateCheck(map);
            } else {
                this.logger.warn("EnigmaScript is missing: this test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.PSTATE)) {
            if (this.compatibility.hasEnigmaScript()) {
                this.addPStateCheck(map);
            } else {
                this.logger.warn("EnigmaScript is missing: this test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.SUMMER)) {
            if (this.compatibility.hasSereneSeasons()) {
                this.addSummerCheck(map);
            } else {
                this.logger.warn("Serene Seaons is missing: this test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.WINTER)) {
            if (this.compatibility.hasSereneSeasons()) {
                this.addWinterCheck(map);
            } else {
                this.logger.warn("Serene Seaons is missing: this test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.SPRING)) {
            if (this.compatibility.hasSereneSeasons()) {
                this.addSpringCheck(map);
            } else {
                this.logger.warn("Serene Seaons is missing: this test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.AUTUMN)) {
            if (this.compatibility.hasSereneSeasons()) {
                this.addAutumnCheck(map);
            } else {
                this.logger.warn("Serene Seaons is missing: this test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.GAMESTAGE)) {
            if (this.compatibility.hasGameStages()) {
                this.addGameStageCheck(map);
            } else {
                this.logger.warn("Game Stages is missing: the 'gamestage' test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.INCITY)) {
            if (this.compatibility.hasLostCities()) {
                this.addInCityCheck(map);
            } else {
                this.logger.warn("The Lost Cities is missing: the 'incity' test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.INSTREET)) {
            if (this.compatibility.hasLostCities()) {
                this.addInStreetCheck(map);
            } else {
                this.logger.warn("The Lost Cities is missing: the 'instreet' test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.INSPHERE)) {
            if (this.compatibility.hasLostCities()) {
                this.addInSphereCheck(map);
            } else {
                this.logger.warn("The Lost Cities is missing: the 'insphere' test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.INBUILDING)) {
            if (this.compatibility.hasLostCities()) {
                this.addInBuildingCheck(map);
            } else {
                this.logger.warn("The Lost Cities is missing: the 'inbuilding' test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.AMULET)) {
            if (this.compatibility.hasBaubles()) {
                this.addBaubleCheck(map, CommonRuleKeys.AMULET, this.compatibility::getAmuletSlots);
            } else {
                this.logger.warn("Baubles is missing: this test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.RING)) {
            if (this.compatibility.hasBaubles()) {
                this.addBaubleCheck(map, CommonRuleKeys.RING, this.compatibility::getRingSlots);
            } else {
                this.logger.warn("Baubles is missing: this test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.BELT)) {
            if (this.compatibility.hasBaubles()) {
                this.addBaubleCheck(map, CommonRuleKeys.BELT, this.compatibility::getBeltSlots);
            } else {
                this.logger.warn("Baubles is missing: this test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.TRINKET)) {
            if (this.compatibility.hasBaubles()) {
                this.addBaubleCheck(map, CommonRuleKeys.TRINKET, this.compatibility::getTrinketSlots);
            } else {
                this.logger.warn("Baubles is missing: this test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.HEAD)) {
            if (this.compatibility.hasBaubles()) {
                this.addBaubleCheck(map, CommonRuleKeys.HEAD, this.compatibility::getHeadSlots);
            } else {
                this.logger.warn("Baubles is missing: this test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.BODY)) {
            if (this.compatibility.hasBaubles()) {
                this.addBaubleCheck(map, CommonRuleKeys.BODY, this.compatibility::getBodySlots);
            } else {
                this.logger.warn("Baubles is missing: this test cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.CHARM)) {
            if (this.compatibility.hasBaubles()) {
                this.addBaubleCheck(map, CommonRuleKeys.CHARM, this.compatibility::getCharmSlots);
            } else {
                this.logger.warn("Baubles is missing: this test cannot work!");
            }
        }
    }

    private void addRandomCheck(AttributeMap map) {
        float r = map.get(CommonRuleKeys.RANDOM).floatValue();
        this.checks.add((event, query) -> rnd.nextFloat() < r);
    }

    private void addSeeSkyCheck(AttributeMap map) {
        if (map.get(CommonRuleKeys.SEESKY).booleanValue()) {
            this.checks.add((event, query) -> query.getWorld(event).func_175710_j(query.getPos(event)));
        } else {
            this.checks.add((event, query) -> !query.getWorld(event).func_175710_j(query.getPos(event)));
        }
    }

    private void addDimensionCheck(AttributeMap map) {
        List<RegistryKey<World>> dimensions = map.getList(CommonRuleKeys.DIMENSION);
        if (dimensions.size() == 1) {
            RegistryKey<World> dim = dimensions.get(0);
            this.checks.add((event, query) -> Tools.getDimensionKey(query.getWorld(event)).equals((Object)dim));
        } else {
            HashSet<RegistryKey<World>> dims = new HashSet<RegistryKey<World>>(dimensions);
            this.checks.add((event, query) -> dims.contains(Tools.getDimensionKey(query.getWorld(event))));
        }
    }

    private void addDimensionModCheck(AttributeMap map) {
        List<String> dimensions = map.getList(CommonRuleKeys.DIMENSION_MOD);
        if (dimensions.size() == 1) {
            String dimmod = dimensions.get(0);
            this.checks.add((event, query) -> Tools.getDimensionKey(query.getWorld(event)).func_240901_a_().func_110624_b().equals(dimmod));
        } else {
            HashSet<String> dims = new HashSet<String>(dimensions);
            this.checks.add((event, query) -> dims.contains(Tools.getDimensionKey(query.getWorld(event)).func_240901_a_().func_110624_b()));
        }
    }

    private void addDifficultyCheck(AttributeMap map) {
        String difficulty = map.get(CommonRuleKeys.DIFFICULTY).toLowerCase();
        Difficulty diff = Difficulty.func_219963_a((String)difficulty);
        if (diff != null) {
            Difficulty finalDiff = diff;
            this.checks.add((event, query) -> query.getWorld(event).func_175659_aa() == finalDiff);
        } else {
            ErrorHandler.error("Unknown difficulty '" + difficulty + "'! Use one of 'easy', 'normal', 'hard',  or 'peaceful'");
        }
    }

    private void addWeatherCheck(AttributeMap map) {
        String weather = map.get(CommonRuleKeys.WEATHER);
        boolean raining = weather.toLowerCase().startsWith("rain");
        boolean thunder = weather.toLowerCase().startsWith("thunder");
        if (raining) {
            this.checks.add((event, query) -> {
                IWorld world = query.getWorld(event);
                if (world instanceof World) {
                    return ((World)world).func_72896_J();
                }
                return false;
            });
        } else if (thunder) {
            this.checks.add((event, query) -> {
                IWorld world = query.getWorld(event);
                if (world instanceof World) {
                    return ((World)world).func_72911_I();
                }
                return false;
            });
        } else {
            ErrorHandler.error("Unknown weather '" + weather + "'! Use 'rain' or 'thunder'");
        }
    }

    private void addCategoryCheck(AttributeMap map) {
        List<String> list = map.getList(CommonRuleKeys.CATEGORY);
        Set categories = list.stream().map(s -> Biome.Category.func_235103_a_((String)s.toLowerCase())).collect(Collectors.toSet());
        this.checks.add((event, query) -> {
            Biome biome = query.getWorld(event).func_226691_t_(query.getPos(event));
            return categories.contains(biome.func_201856_r());
        });
    }

    private void addStructureCheck(AttributeMap map) {
        String structure = map.get(CommonRuleKeys.STRUCTURE);
        this.checks.add((event, query) -> StructureCache.CACHE.isInStructure(query.getWorld(event), structure, query.getPos(event)));
    }

    private void addBiomesCheck(AttributeMap map) {
        List<String> biomes = map.getList(CommonRuleKeys.BIOME);
        if (biomes.size() == 1) {
            String biomename = biomes.get(0);
            this.checks.add((event, query) -> {
                Biome biome = query.getWorld(event).func_226691_t_(query.getPos(event));
                if (Tools.getBiomeId(biome).equals(biomename)) {
                    return true;
                }
                return biomename.equals(this.compatibility.getBiomeName(biome));
            });
        } else {
            HashSet<String> biomenames = new HashSet<String>(biomes);
            this.checks.add((event, query) -> {
                Biome biome = query.getWorld(event).func_226691_t_(query.getPos(event));
                if (biomenames.contains(biome.getRegistryName().toString())) {
                    return true;
                }
                return biomenames.contains(this.compatibility.getBiomeName(biome));
            });
        }
    }

    private void addBiomeTypesCheck(AttributeMap map) {
        List<String> biomeTypes = map.getList(CommonRuleKeys.BIOMETYPE);
        HashSet biomes = new HashSet();
        biomeTypes.stream().map(s -> BiomeManager.BiomeType.valueOf((String)s.toUpperCase())).forEach(type -> BiomeManager.getBiomes((BiomeManager.BiomeType)type).stream().forEach(t -> biomes.add(ForgeRegistries.BIOMES.getValue(t.getKey().getRegistryName()))));
        this.checks.add((event, query) -> {
            Biome biome = query.getWorld(event).func_226691_t_(query.getPos(event));
            return biomes.contains(biome);
        });
    }

    public static <T extends Comparable<T>> BlockState set(BlockState state, Property<T> property, String value) {
        Optional optionalValue = property.func_185929_b(value);
        if (optionalValue.isPresent()) {
            return (BlockState)state.func_206870_a(property, (Comparable)optionalValue.get());
        }
        return state;
    }

    @Nonnull
    private BiFunction<Object, IEventQuery, BlockPos> parseOffset(String json) {
        int offsetZ;
        int offsetY;
        int offsetX;
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(json);
        JsonObject obj = element.getAsJsonObject();
        if (obj.has("offset")) {
            JsonObject offset = obj.getAsJsonObject("offset");
            offsetX = offset.has("x") ? offset.get("x").getAsInt() : 0;
            offsetY = offset.has("y") ? offset.get("y").getAsInt() : 0;
            offsetZ = offset.has("z") ? offset.get("z").getAsInt() : 0;
        } else {
            offsetX = 0;
            offsetY = 0;
            offsetZ = 0;
        }
        if (obj.has("look")) {
            return (event, query) -> {
                RayTraceResult result = LookAtTools.getMovingObjectPositionFromPlayer(query.getWorld(event), query.getPlayer(event), false);
                if (result instanceof BlockRayTraceResult) {
                    return ((BlockRayTraceResult)result).func_216350_a().func_177982_a(offsetX, offsetY, offsetZ);
                }
                return query.getValidBlockPos(event).func_177982_a(offsetX, offsetY, offsetZ);
            };
        }
        return (event, query) -> query.getValidBlockPos(event).func_177982_a(offsetX, offsetY, offsetZ);
    }

    private static boolean testBlockStateSafe(IWorld world, BlockPos pos, Block block) {
        Chunk chunk = world.func_72863_F().func_225313_a(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        if (chunk != null) {
            BlockState state = world.func_180495_p(pos);
            return state.func_177230_c() == block;
        }
        return false;
    }

    private static boolean testBlockStateSafe(IWorld world, BlockPos pos, BlockState block) {
        Chunk chunk = world.func_72863_F().func_225313_a(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        if (chunk != null) {
            BlockState state = world.func_180495_p(pos);
            return state == block;
        }
        return false;
    }

    @Nullable
    private BiPredicate<IWorld, BlockPos> parseBlock(String json) {
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(json);
        if (element.isJsonPrimitive()) {
            String blockname = element.getAsString();
            if (blockname.startsWith("ore:")) {
                return (world, pos) -> false;
            }
            if (!ForgeRegistries.BLOCKS.containsKey(new ResourceLocation(blockname))) {
                ErrorHandler.error("Block '" + blockname + "' is not valid!");
                return null;
            }
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockname));
            return (world, pos) -> CommonRuleEvaluator.testBlockStateSafe(world, pos, block);
        }
        if (element.isJsonObject()) {
            BiPredicate<IWorld, BlockPos> finalTest;
            Predicate<Integer> energy;
            BiPredicate<IWorld, BlockPos> test;
            JsonObject obj = element.getAsJsonObject();
            if (obj.has("ore")) {
                test = (world, pos) -> false;
            } else if (obj.has("block")) {
                String blockname = obj.get("block").getAsString();
                if (!ForgeRegistries.BLOCKS.containsKey(new ResourceLocation(blockname))) {
                    ErrorHandler.error("Block '" + blockname + "' is not valid!");
                    return null;
                }
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockname));
                if (obj.has("properties")) {
                    BlockState blockState = block.func_176223_P();
                    JsonArray propArray = obj.get("properties").getAsJsonArray();
                    for (JsonElement el : propArray) {
                        JsonObject propObj = el.getAsJsonObject();
                        String name = propObj.get("name").getAsString();
                        String value = propObj.get("value").getAsString();
                        for (Property key : blockState.func_235904_r_()) {
                            if (!name.equals(key.func_177701_a())) continue;
                            blockState = CommonRuleEvaluator.set(blockState, key, value);
                        }
                    }
                    BlockState finalBlockState = blockState;
                    test = (world, pos) -> CommonRuleEvaluator.testBlockStateSafe(world, pos, finalBlockState);
                } else {
                    test = (world, pos) -> CommonRuleEvaluator.testBlockStateSafe(world, pos, block);
                }
            } else {
                test = (world, pos) -> true;
            }
            if (obj.has("mod")) {
                String mod = obj.get("mod").getAsString();
                BiPredicate<IWorld, BlockPos> finalTest2 = test;
                test = (world, pos) -> {
                    Chunk chunk = world.func_72863_F().func_225313_a(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
                    if (chunk != null) {
                        return finalTest2.test((IWorld)world, (BlockPos)pos) && mod.equals(world.func_180495_p(pos).func_177230_c().getRegistryName().func_110624_b());
                    }
                    return false;
                };
            }
            if (obj.has("energy") && (energy = CommonRuleEvaluator.getExpression(obj.get("energy"), this.logger)) != null) {
                Direction side = obj.has("side") ? Direction.func_176739_a((String)obj.get("side").getAsString().toLowerCase()) : null;
                finalTest = test;
                test = (world, pos) -> finalTest.test((IWorld)world, (BlockPos)pos) && energy.test(this.getEnergy((IWorld)world, (BlockPos)pos, side));
            }
            if (obj.has("contains")) {
                Direction side = obj.has("side") ? Direction.func_176739_a((String)obj.get("energyside").getAsString().toLowerCase()) : null;
                List<Predicate<ItemStack>> items = this.getItems(obj.get("contains"));
                finalTest = test;
                test = (world, pos) -> finalTest.test((IWorld)world, (BlockPos)pos) && this.contains((IWorld)world, (BlockPos)pos, side, items);
            }
            return test;
        }
        ErrorHandler.error("Block description '" + json + "' is not valid!");
        return null;
    }

    protected List<Predicate<ItemStack>> getItems(JsonElement itemObj) {
        ArrayList<Predicate<ItemStack>> items = new ArrayList<Predicate<ItemStack>>();
        if (itemObj.isJsonObject()) {
            Predicate<ItemStack> matcher = CommonRuleEvaluator.getMatcher(itemObj.getAsJsonObject(), this.logger);
            if (matcher != null) {
                items.add(matcher);
            }
        } else if (itemObj.isJsonArray()) {
            for (JsonElement element : itemObj.getAsJsonArray()) {
                JsonObject obj = element.getAsJsonObject();
                Predicate<ItemStack> matcher = CommonRuleEvaluator.getMatcher(obj, this.logger);
                if (matcher == null) continue;
                items.add(matcher);
            }
        } else {
            ErrorHandler.error("Item description is not valid!");
        }
        return items;
    }

    private boolean isMatchingOreDict(int oreId, Block block) {
        return false;
    }

    private void addBlocksCheck(AttributeMap map) {
        BiFunction<Object, IEventQuery, BlockPos> posFunction = map.has(CommonRuleKeys.BLOCKOFFSET) ? this.parseOffset(map.get(CommonRuleKeys.BLOCKOFFSET)) : (event, query) -> query.getValidBlockPos(event);
        List<String> blocks = map.getList(CommonRuleKeys.BLOCK);
        if (blocks.size() == 1) {
            String json = blocks.get(0);
            BiPredicate<IWorld, BlockPos> blockMatcher = this.parseBlock(json);
            if (blockMatcher != null) {
                this.checks.add((event, query) -> {
                    BlockPos pos = (BlockPos)posFunction.apply(event, (IEventQuery)query);
                    return pos != null && blockMatcher.test(query.getWorld(event), pos);
                });
            }
        } else {
            ArrayList<BiPredicate<IWorld, BlockPos>> blockMatchers = new ArrayList<BiPredicate<IWorld, BlockPos>>();
            for (String block : blocks) {
                BiPredicate<IWorld, BlockPos> blockMatcher = this.parseBlock(block);
                if (blockMatcher == null) {
                    return;
                }
                blockMatchers.add(blockMatcher);
            }
            this.checks.add((event, query) -> {
                BlockPos pos = (BlockPos)posFunction.apply(event, (IEventQuery)query);
                if (pos != null) {
                    IWorld world = query.getWorld(event);
                    for (BiPredicate matcher : blockMatchers) {
                        if (!matcher.test(world, pos)) continue;
                        return true;
                    }
                }
                return false;
            });
        }
    }

    private static boolean isMatchingOreId(int[] oreIDs, int oreId) {
        if (oreIDs.length > 0) {
            for (int id : oreIDs) {
                if (id != oreId) continue;
                return true;
            }
        }
        return false;
    }

    private void addMinTimeCheck(AttributeMap map) {
        int mintime = map.get(CommonRuleKeys.MINTIME);
        this.checks.add((event, query) -> {
            IWorld world = query.getWorld(event);
            if (world instanceof World) {
                long time = ((World)world).func_72820_D();
                return time % 24000L >= (long)mintime;
            }
            return false;
        });
    }

    private void addMaxTimeCheck(AttributeMap map) {
        int maxtime = map.get(CommonRuleKeys.MAXTIME);
        this.checks.add((event, query) -> {
            IWorld world = query.getWorld(event);
            if (world instanceof World) {
                long time = ((World)world).func_72820_D();
                return time % 24000L <= (long)maxtime;
            }
            return false;
        });
    }

    private void addMinSpawnDistCheck(AttributeMap map) {
        Float d = Float.valueOf(map.get(CommonRuleKeys.MINSPAWNDIST).floatValue() * map.get(CommonRuleKeys.MINSPAWNDIST).floatValue());
        this.checks.add((event, query) -> {
            ServerWorld sw;
            BlockPos pos = query.getPos(event);
            double sqdist = pos.func_177951_i((Vector3i)(sw = Tools.getServerWorld(query.getWorld(event))).func_241135_u_());
            return sqdist >= (double)d.floatValue();
        });
    }

    private void addMaxSpawnDistCheck(AttributeMap map) {
        Float d = Float.valueOf(map.get(CommonRuleKeys.MAXSPAWNDIST).floatValue() * map.get(CommonRuleKeys.MAXSPAWNDIST).floatValue());
        this.checks.add((event, query) -> {
            ServerWorld sw;
            BlockPos pos = query.getPos(event);
            double sqdist = pos.func_177951_i((Vector3i)(sw = Tools.getServerWorld(query.getWorld(event))).func_241135_u_());
            return sqdist <= (double)d.floatValue();
        });
    }

    private void addMinLightCheck(AttributeMap map) {
        int minlight = map.get(CommonRuleKeys.MINLIGHT);
        this.checks.add((event, query) -> {
            BlockPos pos = query.getPos(event);
            return query.getWorld(event).func_201696_r(pos) >= minlight;
        });
    }

    private void addMaxLightCheck(AttributeMap map) {
        int maxlight = map.get(CommonRuleKeys.MAXLIGHT);
        this.checks.add((event, query) -> {
            BlockPos pos = query.getPos(event);
            return query.getWorld(event).func_201696_r(pos) <= maxlight;
        });
    }

    private void addMinAdditionalDifficultyCheck(AttributeMap map) {
        Float mindifficulty = map.get(CommonRuleKeys.MINDIFFICULTY);
        this.checks.add((event, query) -> query.getWorld(event).func_175649_E(query.getPos(event)).func_180168_b() >= mindifficulty.floatValue());
    }

    private void addMaxAdditionalDifficultyCheck(AttributeMap map) {
        Float maxdifficulty = map.get(CommonRuleKeys.MAXDIFFICULTY);
        this.checks.add((event, query) -> query.getWorld(event).func_175649_E(query.getPos(event)).func_180168_b() <= maxdifficulty.floatValue());
    }

    private void addMaxHeightCheck(AttributeMap map) {
        int maxheight = map.get(CommonRuleKeys.MAXHEIGHT);
        this.checks.add((event, query) -> query.getY(event) <= maxheight);
    }

    private void addMinHeightCheck(AttributeMap map) {
        int minheight = map.get(CommonRuleKeys.MINHEIGHT);
        this.checks.add((event, query) -> query.getY(event) >= minheight);
    }

    public boolean match(Object event, IEventQuery query) {
        for (BiFunction<Object, IEventQuery, Boolean> rule : this.checks) {
            if (rule.apply(event, query).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private static Predicate<Integer> getExpression(String expression, Logger logger) {
        try {
            if (expression.startsWith(">=")) {
                int amount = Integer.parseInt(expression.substring(2));
                return i -> i >= amount;
            }
            if (expression.startsWith(">")) {
                int amount = Integer.parseInt(expression.substring(1));
                return i -> i > amount;
            }
            if (expression.startsWith("<=")) {
                int amount = Integer.parseInt(expression.substring(2));
                return i -> i <= amount;
            }
            if (expression.startsWith("<")) {
                int amount = Integer.parseInt(expression.substring(1));
                return i -> i < amount;
            }
            if (expression.startsWith("=")) {
                int amount = Integer.parseInt(expression.substring(1));
                return i -> i == amount;
            }
            if (expression.startsWith("!=") || expression.startsWith("<>")) {
                int amount = Integer.parseInt(expression.substring(2));
                return i -> i != amount;
            }
            if (expression.contains("-")) {
                String[] split = StringUtils.split((String)expression, (String)"-");
                int amount1 = Integer.parseInt(split[0]);
                int amount2 = Integer.parseInt(split[1]);
                return i -> i >= amount1 && i <= amount2;
            }
            int amount = Integer.parseInt(expression);
            return i -> i == amount;
        }
        catch (NumberFormatException e) {
            ErrorHandler.error("Bad expression '" + expression + "'!");
            return null;
        }
    }

    private static Predicate<Integer> getExpression(JsonElement element, Logger logger) {
        if (element.isJsonPrimitive()) {
            if (element.getAsJsonPrimitive().isNumber()) {
                int amount = element.getAsInt();
                return i -> i == amount;
            }
            return CommonRuleEvaluator.getExpression(element.getAsString(), logger);
        }
        ErrorHandler.error("Bad expression!");
        return null;
    }

    private static Predicate<ItemStack> getMatcher(String name, Logger logger) {
        ItemStack stack = Tools.parseStack(name, logger);
        if (!stack.func_190926_b()) {
            if (name.contains("/") && name.contains("@")) {
                return s -> ItemStack.func_179545_c((ItemStack)s, (ItemStack)stack) && ItemStack.func_77970_a((ItemStack)s, (ItemStack)stack);
            }
            if (name.contains("/")) {
                return s -> ItemStack.func_185132_d((ItemStack)s, (ItemStack)stack) && ItemStack.func_77970_a((ItemStack)s, (ItemStack)stack);
            }
            if (name.contains("@")) {
                return s -> ItemStack.func_179545_c((ItemStack)s, (ItemStack)stack);
            }
            return s -> s.func_77973_b() == stack.func_77973_b();
        }
        return null;
    }

    private static Predicate<ItemStack> getMatcher(JsonObject obj, Logger logger) {
        Predicate<Integer> energy;
        List<Predicate<CompoundNBT>> nbtMatchers;
        Predicate<ItemStack> finalTest;
        Predicate<Integer> count;
        Predicate<ItemStack> test;
        if (obj.has("empty")) {
            boolean empty = obj.get("empty").getAsBoolean();
            return s -> s.func_190926_b() == empty;
        }
        String name = obj.get("item").getAsString();
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name));
        if (item == null) {
            ErrorHandler.error("Unknown item '" + name + "'!");
            return null;
        }
        if (obj.has("damage")) {
            Predicate<Integer> damage = CommonRuleEvaluator.getExpression(obj.get("damage"), logger);
            if (damage == null) {
                return null;
            }
            test = s -> s.func_77973_b() == item && damage.test(s.func_77952_i());
        } else {
            test = s -> s.func_77973_b() == item;
        }
        if (obj.has("count") && (count = CommonRuleEvaluator.getExpression(obj.get("count"), logger)) != null) {
            finalTest = test;
            test = s -> finalTest.test((ItemStack)s) && count.test(s.func_190916_E());
        }
        if (obj.has("ore")) {
            test = s -> false;
        }
        if (obj.has("mod")) {
            String mod = obj.get("mod").getAsString();
            finalTest = test;
            test = s -> finalTest.test((ItemStack)s) && "mod".equals(s.func_77973_b().getRegistryName().func_110624_b());
        }
        if (obj.has("nbt") && (nbtMatchers = CommonRuleEvaluator.getNbtMatchers(obj, logger)) != null) {
            finalTest = test;
            test = s -> finalTest.test((ItemStack)s) && nbtMatchers.stream().allMatch(p -> p.test(s.func_77978_p()));
        }
        if (obj.has("energy") && (energy = CommonRuleEvaluator.getExpression(obj.get("energy"), logger)) != null) {
            finalTest = test;
            test = s -> finalTest.test((ItemStack)s) && energy.test(CommonRuleEvaluator.getEnergy(s));
        }
        return test;
    }

    private static int getEnergy(ItemStack stack) {
        return stack.getCapability(CapabilityEnergy.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    private boolean contains(IWorld world, BlockPos pos, @Nullable Direction side, @Nonnull List<Predicate<ItemStack>> matchers) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null) {
            return tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).map(h -> {
                for (int i = 0; i < h.getSlots(); ++i) {
                    ItemStack stack = h.getStackInSlot(i);
                    if (stack.func_190926_b()) continue;
                    for (Predicate matcher : matchers) {
                        if (!matcher.test(stack)) continue;
                        return true;
                    }
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    private int getEnergy(IWorld world, BlockPos pos, @Nullable Direction side) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null) {
            return tileEntity.getCapability(CapabilityEnergy.ENERGY, side).map(IEnergyStorage::getEnergyStored).orElse(0);
        }
        return 0;
    }

    private static List<Predicate<CompoundNBT>> getNbtMatchers(JsonObject obj, Logger logger) {
        JsonArray nbtArray = obj.getAsJsonArray("nbt");
        return CommonRuleEvaluator.getNbtMatchers(nbtArray, logger);
    }

    private static List<Predicate<CompoundNBT>> getNbtMatchers(JsonArray nbtArray, Logger logger) {
        ArrayList<Predicate<CompoundNBT>> nbtMatchers = new ArrayList<Predicate<CompoundNBT>>();
        for (JsonElement element : nbtArray) {
            JsonObject o = element.getAsJsonObject();
            String tag = o.get("tag").getAsString();
            if (o.has("contains")) {
                List<Predicate<CompoundNBT>> subMatchers = CommonRuleEvaluator.getNbtMatchers(o.getAsJsonArray("contains"), logger);
                nbtMatchers.add(tagCompound -> {
                    if (tagCompound != null) {
                        ListNBT list = tagCompound.func_150295_c(tag, 10);
                        for (INBT base : list) {
                            for (Predicate matcher : subMatchers) {
                                if (!matcher.test((CompoundNBT)base)) continue;
                                return true;
                            }
                        }
                    }
                    return false;
                });
                continue;
            }
            Predicate<Integer> nbt = CommonRuleEvaluator.getExpression(o.get("value"), logger);
            if (nbt == null) {
                return null;
            }
            nbtMatchers.add(tagCompound -> nbt.test(tagCompound.func_74762_e(tag)));
        }
        return nbtMatchers;
    }

    public static List<Predicate<ItemStack>> getItems(List<String> itemNames, Logger logger) {
        ArrayList<Predicate<ItemStack>> items = new ArrayList<Predicate<ItemStack>>();
        Iterator<String> iterator = itemNames.iterator();
        while (iterator.hasNext()) {
            Predicate<ItemStack> matcher;
            JsonParser parser = new JsonParser();
            String json = iterator.next();
            JsonElement element = parser.parse(json);
            if (element.isJsonPrimitive()) {
                String name = element.getAsString();
                matcher = CommonRuleEvaluator.getMatcher(name, logger);
                if (matcher == null) continue;
                items.add(matcher);
                continue;
            }
            if (element.isJsonObject()) {
                JsonObject obj = element.getAsJsonObject();
                matcher = CommonRuleEvaluator.getMatcher(obj, logger);
                if (matcher == null) continue;
                items.add(matcher);
                continue;
            }
            ErrorHandler.error("Item description '" + json + "' is not valid!");
        }
        return items;
    }

    public void addHelmetCheck(AttributeMap map) {
        List<Predicate<ItemStack>> items = CommonRuleEvaluator.getItems(map.getList(CommonRuleKeys.HELMET), this.logger);
        this.addArmorCheck(items, EquipmentSlotType.HEAD);
    }

    public void addChestplateCheck(AttributeMap map) {
        List<Predicate<ItemStack>> items = CommonRuleEvaluator.getItems(map.getList(CommonRuleKeys.CHESTPLATE), this.logger);
        this.addArmorCheck(items, EquipmentSlotType.CHEST);
    }

    public void addLeggingsCheck(AttributeMap map) {
        List<Predicate<ItemStack>> items = CommonRuleEvaluator.getItems(map.getList(CommonRuleKeys.LEGGINGS), this.logger);
        this.addArmorCheck(items, EquipmentSlotType.LEGS);
    }

    public void addBootsCheck(AttributeMap map) {
        List<Predicate<ItemStack>> items = CommonRuleEvaluator.getItems(map.getList(CommonRuleKeys.BOOTS), this.logger);
        this.addArmorCheck(items, EquipmentSlotType.FEET);
    }

    private void addArmorCheck(List<Predicate<ItemStack>> items, EquipmentSlotType slot) {
        this.checks.add((event, query) -> {
            ItemStack armorItem;
            PlayerEntity player = query.getPlayer(event);
            if (player != null && !(armorItem = player.func_184582_a(slot)).func_190926_b()) {
                for (Predicate item : items) {
                    if (!item.test(armorItem)) continue;
                    return true;
                }
            }
            return false;
        });
    }

    public void addHeldItemCheck(AttributeMap map, Key<String> key) {
        List<Predicate<ItemStack>> items = CommonRuleEvaluator.getItems(map.getList(key), this.logger);
        this.checks.add((event, query) -> {
            ItemStack mainhand;
            PlayerEntity player = query.getPlayer(event);
            if (player != null && !(mainhand = player.func_184614_ca()).func_190926_b()) {
                for (Predicate item : items) {
                    if (!item.test(mainhand)) continue;
                    return true;
                }
            }
            return false;
        });
    }

    public void addOffHandItemCheck(AttributeMap map) {
        List<Predicate<ItemStack>> items = CommonRuleEvaluator.getItems(map.getList(CommonRuleKeys.OFFHANDITEM), this.logger);
        this.checks.add((event, query) -> {
            ItemStack offhand;
            PlayerEntity player = query.getPlayer(event);
            if (player != null && !(offhand = player.func_184592_cb()).func_190926_b()) {
                for (Predicate item : items) {
                    if (!item.test(offhand)) continue;
                    return true;
                }
            }
            return false;
        });
    }

    public void addBothHandsItemCheck(AttributeMap map) {
        List<Predicate<ItemStack>> items = CommonRuleEvaluator.getItems(map.getList(CommonRuleKeys.BOTHHANDSITEM), this.logger);
        this.checks.add((event, query) -> {
            PlayerEntity player = query.getPlayer(event);
            if (player != null) {
                ItemStack mainhand;
                ItemStack offhand = player.func_184592_cb();
                if (!offhand.func_190926_b()) {
                    for (Predicate item : items) {
                        if (!item.test(offhand)) continue;
                        return true;
                    }
                }
                if (!(mainhand = player.func_184614_ca()).func_190926_b()) {
                    for (Predicate item : items) {
                        if (!item.test(mainhand)) continue;
                        return true;
                    }
                }
            }
            return false;
        });
    }

    private void addStateCheck(AttributeMap map) {
        String value;
        String state;
        String s = map.get(CommonRuleKeys.STATE);
        String[] split = StringUtils.split((String)s, (char)'=');
        try {
            state = split[0];
            value = split[1];
        }
        catch (Exception e) {
            ErrorHandler.error("Bad state=value specifier '" + s + "'!");
            return;
        }
        this.checks.add((event, query) -> value.equals(this.compatibility.getState(query.getWorld(event), state)));
    }

    private void addPStateCheck(AttributeMap map) {
        String value;
        String state;
        String s = map.get(CommonRuleKeys.PSTATE);
        String[] split = StringUtils.split((String)s, (char)'=');
        try {
            state = split[0];
            value = split[1];
        }
        catch (Exception e) {
            ErrorHandler.error("Bad state=value specifier '" + s + "'!");
            return;
        }
        this.checks.add((event, query) -> value.equals(this.compatibility.getPlayerState(query.getPlayer(event), state)));
    }

    private void addSummerCheck(AttributeMap map) {
        Boolean s = map.get(CommonRuleKeys.SUMMER);
        this.checks.add((event, query) -> s.booleanValue() == this.compatibility.isSummer(query.getWorld(event)));
    }

    private void addWinterCheck(AttributeMap map) {
        Boolean s = map.get(CommonRuleKeys.WINTER);
        this.checks.add((event, query) -> s.booleanValue() == this.compatibility.isWinter(query.getWorld(event)));
    }

    private void addSpringCheck(AttributeMap map) {
        Boolean s = map.get(CommonRuleKeys.SPRING);
        this.checks.add((event, query) -> s.booleanValue() == this.compatibility.isSpring(query.getWorld(event)));
    }

    private void addAutumnCheck(AttributeMap map) {
        Boolean s = map.get(CommonRuleKeys.AUTUMN);
        this.checks.add((event, query) -> s.booleanValue() == this.compatibility.isAutumn(query.getWorld(event)));
    }

    private void addGameStageCheck(AttributeMap map) {
        String stage = map.get(CommonRuleKeys.GAMESTAGE);
        this.checks.add((event, query) -> this.compatibility.hasGameStage(query.getPlayer(event), stage));
    }

    private void addInCityCheck(AttributeMap map) {
        if (map.get(CommonRuleKeys.INCITY).booleanValue()) {
            this.checks.add((event, query) -> this.compatibility.isCity(query, event));
        } else {
            this.checks.add((event, query) -> !this.compatibility.isCity(query, event));
        }
    }

    private void addInStreetCheck(AttributeMap map) {
        if (map.get(CommonRuleKeys.INSTREET).booleanValue()) {
            this.checks.add((event, query) -> this.compatibility.isStreet(query, event));
        } else {
            this.checks.add((event, query) -> !this.compatibility.isStreet(query, event));
        }
    }

    private void addInSphereCheck(AttributeMap map) {
        if (map.get(CommonRuleKeys.INSPHERE).booleanValue()) {
            this.checks.add((event, query) -> this.compatibility.inSphere(query, event));
        } else {
            this.checks.add((event, query) -> !this.compatibility.inSphere(query, event));
        }
    }

    private void addInBuildingCheck(AttributeMap map) {
        if (map.get(CommonRuleKeys.INBUILDING).booleanValue()) {
            this.checks.add((event, query) -> this.compatibility.isBuilding(query, event));
        } else {
            this.checks.add((event, query) -> !this.compatibility.isBuilding(query, event));
        }
    }

    public void addBaubleCheck(AttributeMap map, Key<String> key, Supplier<int[]> slotSupplier) {
        List<Predicate<ItemStack>> items = CommonRuleEvaluator.getItems(map.getList(key), this.logger);
        this.checks.add((event, query) -> {
            PlayerEntity player = query.getPlayer(event);
            if (player != null) {
                for (int slot : (int[])slotSupplier.get()) {
                    ItemStack stack = this.compatibility.getBaubleStack(player, slot);
                    if (stack.func_190926_b()) continue;
                    for (Predicate item : items) {
                        if (!item.test(stack)) continue;
                        return true;
                    }
                }
            }
            return false;
        });
    }
}

